<?php
require __DIR__ . '/../auth_check.php';

$input = json_decode(file_get_contents('php://input'), true);

$path     = $input['path'] ?? '';
$checksum = $input['checksum'] ?? '';

if (!$path || !$checksum) {
    http_response_code(400);
    exit;
}

$pdo->prepare("
  INSERT INTO canary_files (user_id, device_id, path, checksum)
  VALUES (?, ?, ?, ?)
  ON DUPLICATE KEY UPDATE checksum = VALUES(checksum)
")->execute([
  $auth['uid'],
  $auth['device_id'] ?? 0,
  $path,
  $checksum
]);

echo json_encode(['status' => 'ok']);
