<?php
require __DIR__ . '/../core/db.php';
require __DIR__ . '/../core/notify/NotificationService.php';

$q = $pdo->query("
SELECT id, expires_on
FROM users
WHERE expires_on IS NOT NULL
  AND DATEDIFF(expires_on, CURDATE()) IN (7,3,1)
");

foreach ($q as $u) {
  NotificationService::push($pdo, [
    'user_id' => $u['id'],
    'title'   => 'Subscription Expiring',
    'message' => 'Your subscription expires soon. Please renew.',
    'type'    => 'billing'
  ]);
}
