<?php
if (php_sapi_name() !== 'cli') {
    http_response_code(403);
    exit('Forbidden');
}
require __DIR__.'/../core/db.php';
require __DIR__.'/../core/storage/StorageFactory.php';

$users = $pdo->query("SELECT * FROM canary_files")->fetchAll();

foreach ($users as $u) {
  $path = "/{$u['user_id']}/.canary_DO_NOT_TOUCH.txt";

  try {
    $storage = getStorage(/* primary server */);
    $content = $storage->read($path);
    $hash = hash('sha256', $content);

    if ($hash !== $u['checksum']) {
      $pdo->prepare("
        INSERT INTO incidents (user_id,type,severity,details)
        VALUES (?,?,?,?)
      ")->execute([
        $u['user_id'],
        'canary',
        'critical',
        'Canary file modified'
      ]);
    }
  } catch (Exception $e) {}
}
