<?php
require_once __DIR__ . "/StorageSupport.php";
require_once __DIR__ . "/SftpStorage.php";
require_once __DIR__ . "/FtpStorage.php";
require_once __DIR__ . "/HttpProxyStorage.php";
// require_once __DIR__ . "/S3Storage.php"; // later

function getStorage(array $server) {
    $config = json_decode($server['config'], true);
    if (!$config) {
        throw new Exception("Invalid storage config");
    }

    switch ($server['type']) {

        case 'sftp':
            if (!supportsSftp()) {
                throw new Exception("SSH2 not available");
            }
            return new SftpStorage($config);

        case 'ftp':
            return new FtpStorage($config);

        case 'http':
            return new HttpProxyStorage($config);

        case 's3':
            throw new Exception("S3 not implemented yet");

        default:
            throw new Exception("Unsupported storage type");
    }
}
