<?php
class SftpStorage {
    private $conn;
    private $sftp;
    private $basePath;

    public function __construct(array $cfg) {
        $this->conn = ssh2_connect($cfg['host'], $cfg['port'] ?? 22);
        if (!$this->conn) throw new Exception("SFTP connection failed");

        if (!ssh2_auth_password(
            $this->conn,
            $cfg['username'],
            $cfg['password']
        )) {
            throw new Exception("SFTP auth failed");
        }

        $this->sftp = ssh2_sftp($this->conn);
        $this->basePath = rtrim($cfg['base_path'], '/');
    }

    public function upload(string $local, string $remote): void {
        $path = $this->basePath . $remote;
        $this->mkdir(dirname($path));

        if (!ssh2_scp_send($this->conn, $local, $path, 0644)) {
            throw new Exception("SFTP upload failed");
        }
    }

    private function mkdir(string $dir): void {
        $parts = explode('/', trim($dir, '/'));
        $p = '';
        foreach ($parts as $part) {
            $p .= "/$part";
            @ssh2_sftp_mkdir($this->sftp, $p, 0755);
        }
    }
}
