<?php
class HttpProxyStorage {
    private $endpoint;
    private $apiKey;

    public function __construct(array $cfg) {
        $this->endpoint = $cfg['endpoint'];
        $this->apiKey = $cfg['api_key'];
    }

    public function upload(string $local, string $remote): void {
        $ch = curl_init($this->endpoint);

        $post = [
            'file' => new CURLFile($local),
            'path' => $remote,
            'key'  => $this->apiKey
        ];

        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
            CURLOPT_RETURNTRANSFER => true,
        ]);

        $res = curl_exec($ch);
        if (!$res) throw new Exception("HTTP proxy upload failed");

        curl_close($ch);
    }
}
