<?php
class FtpStorage {
    private $ftp;
    private $basePath;

    public function __construct(array $cfg) {
        $this->ftp = ftp_connect($cfg['host']);
        if (!$this->ftp) throw new Exception("FTP connect failed");

        if (!ftp_login($this->ftp, $cfg['username'], $cfg['password'])) {
            throw new Exception("FTP login failed");
        }

        ftp_pasv($this->ftp, true);
        $this->basePath = rtrim($cfg['base_path'], '/');
    }

    public function upload(string $local, string $remote): void {
        $path = $this->basePath . $remote;
        $this->mkdir(dirname($path));

        if (!ftp_put($this->ftp, $path, $local, FTP_BINARY)) {
            throw new Exception("FTP upload failed");
        }
    }

    private function mkdir(string $dir): void {
        $parts = explode('/', trim($dir, '/'));
        $p = '';
        foreach ($parts as $part) {
            $p .= "/$part";
            @ftp_mkdir($this->ftp, $p);
        }
    }
}
