<?php
class DeviceIsolationService {

    public static function block(PDO $pdo, int $deviceId, string $reason): void
    {
        // Block device
        $pdo->prepare("
            UPDATE user_devices
            SET blocked = 1, risk_score = 1.0
            WHERE id = ?
        ")->execute([$deviceId]);

        // Log incident
        $pdo->prepare("
            INSERT INTO incidents (user_id, device_id, type, severity, details)
            SELECT user_id, id, 'device', 'critical', ?
            FROM user_devices WHERE id = ?
        ")->execute([$reason, $deviceId]);
    }

    public static function unblock(PDO $pdo, int $deviceId): void
    {
        $pdo->prepare("
            UPDATE user_devices
            SET blocked = 0, risk_score = 0
            WHERE id = ?
        ")->execute([$deviceId]);
    }
}
