<?php
// require "../core/db.php";
// require "../core/jwt.php";

// $data = json_decode(file_get_contents("php://input"), true);

// $stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND status=1");
// $stmt->execute([$data['email']]);
// $user = $stmt->fetch();

// if (!$user || !password_verify($data['password'], $user['password_hash'])) {
//     http_response_code(401);
//     exit(json_encode(["error"=>"Invalid credentials"]));
// }

// $token = jwt_encode([
//   "uid" => $user['id'],
//   "role" => $user['role'],
//   "exp" => time() + 86400
// ]);

// echo json_encode(["token"=>$token]);

// api/auth/login.php updated version

header("Content-Type: application/json");

require __DIR__ . "/../core/db.php";
require __DIR__ . "/../core/jwt.php";

// -------------------------------------------------
// INPUT
// -------------------------------------------------
$input = json_decode(file_get_contents("php://input"), true);

$email        = trim($input['email'] ?? '');
$password     = $input['password'] ?? '';
$deviceToken  = $input['device_token'] ?? '';
$deviceType   = $input['device_type'] ?? 'unknown';
$deviceName   = $input['device_name'] ?? 'Unknown Device';

if (!$email || !$password || !$deviceToken) {
    http_response_code(400);
    exit(json_encode(["error" => "Missing credentials or device info"]));
}

// -------------------------------------------------
// USER AUTH
// -------------------------------------------------
$stmt = $pdo->prepare("
    SELECT id, password_hash, role, status
    FROM users
    WHERE email = ?
    LIMIT 1
");
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || !password_verify($password, $user['password_hash'])) {
    http_response_code(401);
    exit(json_encode(["error" => "Invalid email or password"]));
}

if ((int)$user['status'] !== 1) {
    http_response_code(403);
    exit(json_encode(["error" => "Account disabled"]));
}

$userId = (int)$user['id'];

// -------------------------------------------------
// DEVICE REGISTRATION / UPDATE
// -------------------------------------------------
$stmt = $pdo->prepare("
    SELECT id, is_blocked
    FROM user_devices
    WHERE user_id = ? AND device_token = ?
    LIMIT 1
");
$stmt->execute([$userId, $deviceToken]);
$device = $stmt->fetch(PDO::FETCH_ASSOC);

if ($device) {

    // 🚫 BLOCKED DEVICE
    if (!empty($device['is_blocked'])) {
        http_response_code(403);
        exit(json_encode([
            "error" => "This device has been blocked by administrator"
        ]));
    }

    // Update last seen
    $pdo->prepare("
        UPDATE user_devices
        SET last_seen = NOW()
        WHERE id = ?
    ")->execute([$device['id']]);

} else {

    // ➕ REGISTER NEW DEVICE
    $pdo->prepare("
        INSERT INTO user_devices
            (user_id, device_name, device_type, device_token, last_seen, is_blocked)
        VALUES
            (?, ?, ?, ?, NOW(), 0)
    ")->execute([
        $userId,
        $deviceName,
        $deviceType,
        $deviceToken
    ]);
}

// -------------------------------------------------
// ISSUE JWT
// -------------------------------------------------
$token = jwt_encode([
    'uid'  => $userId,
    'role' => $user['role'],
    'iat'  => time(),
    'exp'  => time() + (60 * 60 * 24 * 30) // 30 days
]);

echo json_encode([
    "status" => "success",
    "token"  => $token
]);
